package com.ejie.ab18a.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Clase que mantiene una hash de ficheros de configuracion. Es un patr�n
 * singleton que carga las propiedad en el primer acceso
 * 
 * @author XXXX
 */

public final class Ab18aPropertiesManager {

	/** The Constant LOGGER. */
	private static final Logger logger = LoggerFactory
			.getLogger(Ab18aPropertiesManager.class);

	// Referencia a s� mismo por tratarse de un singletton
	private static Ab18aPropertiesManager instance;

	// Fichero de configuraci�n principal de la aplicacion
	private static final String APP_PROPERTIES = "/ab18a/ab18a.properties";

	// Hashtable donde se almacenan los ficheros de propiedades
	private static Properties properties;

	/**
	 * Constructor privado definido siguiendo el patr�n Singleton para la
	 * gesti�n del fichero de configuraci�n
	 * 
	 * @throws IOException
	 *             Error al no localizar el fichero
	 */
	private Ab18aPropertiesManager() throws IOException {
		Ab18aPropertiesManager.properties = new Properties();

		Ab18aPropertiesManager.properties.put("charSet", "UTF-8");

		final InputStream inProp = this.getClass().getResourceAsStream(
				Ab18aPropertiesManager.APP_PROPERTIES);
		if (inProp != null) {
			Ab18aPropertiesManager.properties.load(inProp);

			final Enumeration<?> enume = Ab18aPropertiesManager.properties
					.keys();
			while (enume.hasMoreElements()) {
				final String key = (String) enume.nextElement();
				Ab18aPropertiesManager.logger.debug("[" + key + "] - ["
						+ Ab18aPropertiesManager.properties.getProperty(key)
						+ "]");
			}
		} else {
			Ab18aPropertiesManager.logger
					.info("no se ha podido recuperar el fichero de propiedades");
		}
	}

	/**
	 * Recuperar propiedades del fichero de configuracion
	 * 
	 * @param key
	 *            clave de la propiedad
	 * @return valor de la propiedad. "" si no existe.
	 */
	public static synchronized String getProperty(final String key) {
		String rtdo = "";
		try {
			if (Ab18aPropertiesManager.instance == null) {
				Ab18aPropertiesManager.instance = new Ab18aPropertiesManager();
			}
			rtdo = Ab18aPropertiesManager.properties.getProperty(key, "");
			Ab18aPropertiesManager.logger.debug("[" + key + "] = [" + rtdo
					+ "]");
		} catch (Exception e) {
			Ab18aPropertiesManager.logger
					.info("Error al obtener el Y46jPropertiesManager (Exception): "
							+ e.getMessage());
		}

		return rtdo;
	}

}
